# the autosyncwizard edgematchstrategy tab

			group edgematchstrategy {
				title above center "Edge Match Strategy";
				geometry 0, 0, 650, 378;
				lock top, bottom, left, right;
				
				textnumber rmsthresh;
				textnumber bufferwidth;
				group dtmgroup;

				label edgematchpageinfo {
					value "Edge matching is performed on neighboring images by refining their geometric models using a selected method.\nYou can apply refinement to the overlapping area only or to the whole image. If you select Overlapping Area Only,\nyou can set a buffer to achieve a smoother transition.";
					geometry 5, 5, 600, 26;
					lock top, left, width, height;
				}

				popuplist adjmethod {
					title left center "Refinement Method:";
					geometry 15, 75, 320, 26;
					lock top, left, width, height;
					info "Select geometric model for output images";
					titleoffset 165 noalign;
					titlelist {
						"Affine",
						"Polynomial",
						"Linear Rubber Sheeting",
						"Nonlinear Rubber Sheeting"
					};
					names {
						"Affine",
						"Polynomial",
						"Linear Rubber Sheeting",
						"Nonlinear Rubber Sheeting"
					};
					on valuechanged {
						if ($adjmethod == "Affine") {
							hide polyorder;
							enable rmsthresh;
						}
						else if ($adjmethod == "Polynomial") {
							show polyorder;
							enable rmsthresh;
						}
						else if ($adjmethod == "Linear Rubber Sheeting") {
							hide polyorder;
							disable rmsthresh;
						}
						else if ($adjmethod == "Nonlinear Rubber Sheeting") {
							hide polyorder;
							disable rmsthresh;
						}
								
						if (GetGMNeedsElevation () == 1) {
							show dtmgroup;
						}
						else {
							hide dtmgroup;
						}
					}
					on input {
						SetEdgeMatchMethod ($adjmethod);
					}
				}

				textnumber polyorder {
					title left center "Maximum Polynomial Order:";
					info "Maximal order of polynomial to use";
					lock top,left,width,height;
					geometry 365,75,200,26;
					titleoffset 150 noalign;
					min 1;
					max 99;
					value 3;
					on input {
						SetEdgeMatchPolyOrder($polyorder);
					}
				}

				textnumber rmsthresh {
					title left center "RMS Threshold:";
					geometry 15, 110, 320, 26;
					lock top, left, width, height;
					info "Specify maximum acceptable RMS error for syncing output images";
					titleoffset 165 noalign;
					min 0;
					max 999.9999;
					format "8.4";
					on input {
						SetOutputRMSThreshold($rmsthresh);
					}
				}
				
				radiobutton applyedgemethto {
					title left center "Apply Refinement to:";
					geometry 15, 145, 450, 26;
					lock top, left, width, height;
					info "Apply edge matching to overlapping area only or to entire image";
					titleoffset 162 noalign;
					layout horizontal;
					titlelist { 
						"Overlapping Area Only",
						"Whole Image"
					};
					options {
						"Overlapping Area Only",
						"Whole Image"
					};
					on valuechanged {
						if ($applyedgemethto == "Overlapping Area Only") {
							show bufferwidth;
						}
						else {
							hide bufferwidth;
						}
					}
					on input {
						SetApplyEdgeMatchTo($applyedgemethto);
					}
				}
				
				textnumber bufferwidth {
					title left center "Buffer Around the Overlapping Area (pixels):";
					geometry 15, 180, 320, 26;
					lock top, left, width, height;
					info "Specify the extent of the buffer around the overlapping area";
					titleoffset 235 noalign;
					min 0;
					max 1000000;
					on input {
						SetBufferWidth($bufferwidth);
					}
				}

				radiobutton dtmsource {
					title left center "DTM Source:";
					geometry 3, 0, 300, 20;
					lock top, left, width, height;
					info "Select to specify a constant value for elevation or one or more DTMs.";
					layout horizontal;
					titlelist {
						"constant value",
						"DTM database"
					};
					options {
						"constant",
						"database"
					};
				}
		
				on groupdisplay {
					hide dtmsource;
					setmodelparts();
					set rmsthresh = GetOutputRMSThreshold();
					set applyedgemethto = GetApplyEdgeMatchTo();
					set bufferwidth = GetBufferWidth();
					set adjmethod = GetEdgeMatchMethod();
					set polyorder = GetEdgeMatchPolyOrder();
				}
			}
